
#ifndef _ENEMY_H_
#define _ENEMY_H_

#include "main.h"
#include <string>
#include "sceneModel.h"

static const float ENEMY_JUMP_SPEED = 1.f;

class CEnemy : public CSceneModel
{
public:
	CEnemy() : m_move(D3DXVECTOR3(0.f, 0.f, 0.f)), m_frictional(0.8f) { SetObjType(OBJTYPE::ENEMY); }
	~CEnemy() {}

	void Init(void);
	void Uninit(void);
	void Update(void);
	void Draw(void);
	CEnemy *Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass);

	int RightorLeft(D3DXVECTOR2 Vec1, D3DXVECTOR2 Vec2, D3DXVECTOR2 pos);

	const float &GetFrictional(void)const { return m_frictional; }
	const D3DXVECTOR3 &GetMove(void)const { return m_move; }
private:
	D3DXVECTOR3 m_move;
	float m_frictional;			// C
	bool m_jump;

	int m_life;
};

#endif